/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.path;

import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.rcs.conndata.LparInfo;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;

public class RemoteServiceDialPath
extends RcsPath {
    private static final String TRACE_MASKT = "XRCSSVPT";
    private static final String TRACE_MASKF = "XRCSSVPF";
    private static final String TRACE_MASKD = "XRCSSVPD";
    private String stationAddress;
    private boolean localAccess;
    private CecInfo localInfo;
    private CecInfo cecInfo;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$RemoteServiceDialLink;

    public RemoteServiceDialPath(String stationAddress, boolean localAccess, CecInfo localInfo, CecInfo cecInfo) {
        this(PathPriority.HIGH, new LocalizableText("Remove Service Dial"), stationAddress, localAccess, localInfo, cecInfo);
    }

    public RemoteServiceDialPath(LocalizableText text, String stationAddress, boolean localAccess, CecInfo localInfo, CecInfo cecInfo) {
        this(PathPriority.HIGH, text, stationAddress, localAccess, localInfo, cecInfo);
    }

    public RemoteServiceDialPath(PathPriority priority, LocalizableText text, String stationAddress, boolean localAccess, CecInfo localInfo, CecInfo cecInfo) {
        super(priority, text);
        this.stationAddress = stationAddress;
        this.localAccess = localAccess;
        this.localInfo = localInfo;
        this.cecInfo = cecInfo;
        ArrayList<Class> links = new ArrayList<Class>();
        links.add(class$com$ibm$hwmca$fw$rcs$link$RemoteServiceDialLink == null ? (class$com$ibm$hwmca$fw$rcs$link$RemoteServiceDialLink = RemoteServiceDialPath.class$("com.ibm.hwmca.fw.rcs.link.RemoteServiceDialLink")) : class$com$ibm$hwmca$fw$rcs$link$RemoteServiceDialLink);
        this.setSupportedLinkTypes(links);
    }

    public void open() throws InvalidStateException, PathCancelledException, PathFailedException {
        Trace.trace(TRACE_MASKT, "--> open()");
        RcsConfig config = RcsConfig.getRcsConfig();
        config.setTemporaryConfigValue("rs_hmc_allow", this.localAccess ? "1" : "0");
        config.setTemporaryConfigValue("rs_hmc_station", this.stationAddress);
        config.setTemporaryConfigValue("rs_ppp_user", "QPGMR");
        config.setTemporaryConfigValue("rs_ppp_pw", "RMTSPT" + this.stationAddress.toUpperCase());
        if (this.localInfo != null) {
            config.setTemporaryConfigValue("rs_hmc_mtms", this.localInfo.getType() + "-" + this.localInfo.getModel() + "*" + this.localInfo.getSerial());
        } else {
            config.setTemporaryConfigValue("rs_hmc_mtms", "00000-0000*000000");
        }
        if (this.cecInfo != null && this.cecInfo.getPartitions() != null) {
            Iterator i = this.cecInfo.getPartitions().iterator();
            for (int pId = 0; pId <= 5; ++pId) {
                if (i.hasNext()) {
                    LparInfo info = (LparInfo)i.next();
                    config.setTemporaryConfigValue("rs_cec_" + pId, info.getNumber() + "*" + info.getType() + "-" + info.getModel() + "*" + info.getSerial());
                    continue;
                }
                config.setTemporaryConfigValue("rs_cec_" + pId, "");
            }
        } else {
            for (int pId = 0; pId <= 5; ++pId) {
                config.setTemporaryConfigValue("rs_cec_" + pId, "");
            }
        }
        super.open();
        Trace.trace(TRACE_MASKT, "<-- open()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

